//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Item {
    id : uiDateTimeEdit

    property date date
    property date minimumDate
    property date maximumDate
    property bool bindable

    signal updateRequested(date newValue)

    activeFocusOnTab : true
    implicitWidth    : content.implicitWidth
    implicitHeight   : content.implicitHeight

    onActiveFocusChanged : {
        if (activeFocus) {
            if (!dateEdit.activeFocus && !timeEdit.activeFocus)
                dateEdit.forceActiveFocus();
        } else {
            focus = false;
        }
    }

    Row {
        id : content

        spacing : 4

        function setDate(date) {
            if (uiDateTimeEdit.bindable) {
                uiDateTimeEdit.updateRequested(date);
            } else {
                uiDateTimeEdit.date = date;
            }
        }

        UiDateEdit {
            id : dateEdit

            bindable    : true
            date        : uiDateTimeEdit.date
            minimumDate : uiDateTimeEdit.minimumDate
            maximumDate : uiDateTimeEdit.maximumDate

            onUpdateRequested : {
                var date = uiDateTimeEdit.date;

                date.setFullYear(newValue.getFullYear());
                date.setMonth(newValue.getMonth());
                date.setDate(newValue.getDate());

                content.setDate(date);
            }
        }

        UiTimeEdit {
            id : timeEdit

            bindable : true
            time     : uiDateTimeEdit.date

            onUpdateRequested : {
                if (uiDateTimeEdit.date.getFullYear() > 0) {
                    var date = uiDateTimeEdit.date;
                } else {
                    date = new Date();
                }

                date.setHours(newValue.getHours());
                date.setMinutes(newValue.getMinutes());
                date.setSeconds(0);
                date.setMilliseconds(0);

                content.setDate(date);
            }
        }
    }
}
